#include "stdio.h"
#include "stdlib.h"
#include "pthread.h"
#include "time.h"
#include "unistd.h"

// BROJ VOZILA
#define N 10

// TIPOVI VOZILA
#define AUTOMOBIL 0
#define AUTOBUS 1
#define KAMION 2

// SMEROVI
#define SLOBODNO 0
#define SEVER 1
#define JUG 2


pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t condSever = PTHREAD_COND_INITIALIZER;
pthread_cond_t condJug = PTHREAD_COND_INITIALIZER;
pthread_cond_t condBusSever = PTHREAD_COND_INITIALIZER;
pthread_cond_t condBusJug = PTHREAD_COND_INITIALIZER;
pthread_cond_t condKamionSever = PTHREAD_COND_INITIALIZER;
pthread_cond_t condKamionJug = PTHREAD_COND_INITIALIZER;


int cekaSever=0;
int cekaJug=0;
int prelaziSever=0;
int prelaziJug=0;
int brAutomobila=0;
int brKamiona=0;
int brAutobusa=0;
int smer=SLOBODNO;

void *predjiMostSever(void *arg)
{
    long id=(long)arg;
    int tip = rand()%3;
    sleep(rand()%5);
    pthread_mutex_lock(&mutex);
    cekaSever++;
    if(tip==AUTOMOBIL)
    {
        printf("Automobil %ld stize na most sa severa\n",id);
        while(smer==JUG || (smer==SEVER && brKamiona>0))
            pthread_cond_wait(&condSever,&mutex);
        smer=SEVER;
        cekaSever--;
        prelaziSever++;
        brAutomobila++;
        pthread_mutex_unlock(&mutex);
        printf("Automobil %ld prelazi most sa severa\n",id);
        sleep(rand()%3);
        printf("Automobil %ld presao most sa severa\n",id);
        pthread_mutex_lock(&mutex);
        brAutomobila--;
        prelaziSever--;
        if(prelaziSever==0 && cekaSever==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condJug);
        }
        pthread_mutex_unlock(&mutex);

    }
    else if(tip==AUTOBUS)
    {
        printf("Autobus %ld stize na most sa severa\n",id);
        while(smer==JUG || (smer==SEVER && brKamiona>0) || (smer==SEVER && brAutobusa>0))
            pthread_cond_wait(&condSever,&mutex);
        smer=SEVER;
        cekaSever--;
        prelaziSever++;
        brAutobusa++;
        pthread_mutex_unlock(&mutex);
        printf("Autobus %ld prelazi most sa severa\n",id);
        sleep(rand()%3);
        printf("Autobus %ld presao most sa severa\n",id);
        pthread_mutex_lock(&mutex);
        brAutobusa--;
        prelaziSever--;
        if(prelaziSever==0 && cekaSever==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condJug);
        }
        pthread_mutex_unlock(&mutex);
    }
    else
    {
        printf("Kamion %ld stize na most sa severa\n",id);
        while(smer==JUG || (smer==SEVER && brKamiona>0) || (smer==SEVER && brAutobusa>0) || (smer==SEVER && brAutomobila>0))
            pthread_cond_wait(&condSever,&mutex);
        smer=SEVER;
        cekaSever--;
        prelaziSever++;
        brKamiona++;
        pthread_mutex_unlock(&mutex);
        printf("Kamion %ld prelazi most sa severa\n",id);
        sleep(rand()%3);
        printf("Kamion %ld presao most sa severa\n",id);
        pthread_mutex_lock(&mutex);
        brKamiona--;
        prelaziSever--;
        if(prelaziSever==0 && cekaSever==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condJug);
        }
        pthread_mutex_unlock(&mutex);
    }
    return NULL;
}

void *predjiMostJug(void *arg)
{
    long id=(long)arg;
    int tip = rand()%3;
    sleep(rand()%5);
    pthread_mutex_lock(&mutex);
    cekaJug++;
    if(tip==AUTOMOBIL)
    {
        printf("Automobil %ld stize na most sa juga\n",id);
        while(smer==SEVER || (smer==JUG && brKamiona>0))
            pthread_cond_wait(&condJug,&mutex);
        smer=JUG;
        cekaJug--;
        prelaziJug++;
        brAutomobila++;
        pthread_mutex_unlock(&mutex);
        printf("Automobil %ld prelazi most sa juga\n",id);
        sleep(rand()%3);
        printf("Automobil %ld presao most sa juga\n",id);
        pthread_mutex_lock(&mutex);
        brAutomobila--;
        prelaziJug--;
        if(prelaziJug==0 && cekaJug==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);

    }
    else if(tip==AUTOBUS)
    {
        printf("Autobus %ld stize na most sa juga\n",id);
        while(smer==SEVER || (smer==JUG && brKamiona>0) || (smer==JUG && brAutobusa>0))
            pthread_cond_wait(&condJug,&mutex);
        smer=JUG;
        cekaJug--;
        prelaziJug++;
        brAutobusa++;
        pthread_mutex_unlock(&mutex);
        printf("Autobus %ld prelazi most sa juga\n",id);
        sleep(rand()%3);
        printf("Autobus %ld presao most sa juga\n",id);
        pthread_mutex_lock(&mutex);
        brAutobusa--;
        prelaziJug--;
        if(prelaziJug==0 && cekaJug==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);
    }
    else
    {
        printf("Kamion %ld stize na most sa juga\n",id);
        while(smer==SEVER || (smer==JUG && brKamiona>0) || (smer==JUG && brAutobusa>0) || (smer==JUG && brAutomobila>0))
            pthread_cond_wait(&condJug,&mutex);
        smer=JUG;
        cekaJug--;
        prelaziJug++;
        brKamiona++;
        pthread_mutex_unlock(&mutex);
        printf("Kamion %ld prelazi most sa juga\n",id);
        sleep(rand()%3);
        printf("Kamion %ld presao most sa juga\n",id);
        pthread_mutex_lock(&mutex);
        brKamiona--;
        prelaziJug--;
        if(prelaziJug==0 && cekaJug==0)
        {
            smer=SLOBODNO;
            pthread_cond_broadcast(&condSever);
        }
        pthread_mutex_unlock(&mutex);
    }
    return NULL;
}

int main()
{
    srand(time(NULL));
    pthread_t vozila1[N];
    pthread_t vozila2[N];

    for(int i=0;i<N;i++)
    {
        pthread_create(&vozila1[i],NULL,predjiMostSever,(void *)i);
        pthread_create(&vozila2[i],NULL,predjiMostJug,(void *)i);
    }
    
    for(int i=0;i<N;i++)
    {
        pthread_join(vozila1[i],NULL);
    }

    for(int i=0;i<N;i++)
    {
        pthread_join(vozila2[i],NULL);
    }

    pthread_exit(NULL);
}